/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.dao.CheckDao;
import com.dao.PaymentDao;
import com.dao.SarfaslDao;
import com.dao.process.PaymentProcessDao;
import com.dao.process.ProcessDao;
import com.dao.use_case.KainoLoginUseCase;
import com.dao.use_case.ValidateMobileUseCase;
import com.dao.use_case.ValidateVoucherUseCase;
import com.dao.use_case.dto.ValidateMobileResponse;
import com.dao.use_case.dto.ValidateVoucherResponse;
import com.dao.util.PosLogBulkInsert;
import com.dao.util.SetOffIdentInsert;
import com.dao.util.SettingBulkInsert;
import com.dto.ApiResponse;
import com.dto.BankDto;
import com.dto.CheckDto;
import com.dto.CheckEventDto;
import com.dto.InvoiceDetailDto;
import com.dto.LoginDto;
import com.dto.PaymentDetailDto;
import com.dto.PaymentDetailSndIndxDto;
import com.dto.PaymentDto;
import com.dto.PosTransactionDto;
import com.dto.ProxyVoucherDtl;
import com.dto.ProxyVoucherDto;
import com.dto.SarfaslDto;
import com.dto.SettingDto;
import com.dto.restaurant.ResInvoiceDto;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.service.invoice.CheckPayError;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.ExceptionUtils;
import com.utility.GetIdentity;
import com.utility.JsonDeserializer;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import com.utility.TncLog;
import com.utility.TransactionCheck;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class PaymentDao {
    private final LinkedList<PaymentDetailDto> sndList = new LinkedList();
    private final DbConnection dbConnection;
    private final SarfaslDao sarfaslDao;
    private final TncLog log;
    private final ValidateVoucherUseCase validateVoucherUseCase;
    private final KainoLoginUseCase kainoLoginUseCase;
    private final ValidateMobileUseCase validateMobileUseCase;

    public PaymentDao(DbConnection dbConnection, SarfaslDao sarfaslDao, TncLog log, ValidateVoucherUseCase validateVoucherUseCase, KainoLoginUseCase kainoLoginUseCase, ValidateMobileUseCase validateMobileUseCase) {
        this.dbConnection = dbConnection;
        this.sarfaslDao = sarfaslDao;
        this.log = log;
        this.validateVoucherUseCase = validateVoucherUseCase;
        this.kainoLoginUseCase = kainoLoginUseCase;
        this.validateMobileUseCase = validateMobileUseCase;
    }

    @NotNull
    private StringBuilder getInsertStatement(int sType) {
        StringBuilder sb = new StringBuilder();
        switch (sType) {
            case 0: {
                sb.append("Insert Into Sanad(Sanad_code,Sanad_code_c,Sanad_Code_C2,Sanad_Date,Sanad_Time,Comment,End_Save,SaveFromFacture,SaveFromAuto,Sanad_Type,UserCodeInc,sanad_state)");
                break;
            }
            case 1: {
                sb.append("Insert Into Snd_List(Sanad_code,Col_Code,Moien_Code,Tafzili_Code,Bed,Bes,Show_Daftar,Joze,Type_Line,Number_Line,Comment_Line,OldSCode)");
                break;
            }
            case 2: {
                sb.append("Insert Into Sarfasl(Col_Code,Moien_Code,Tafzili_Code,Sarfasl_Code,Sarfasl_Name,Mandeh,[Group],Mahiat,Can_Delete,Common,[Delete],MHaz_Code,AutoUse,ID,Parent,Type,SParent)");
                break;
            }
            case 3: {
                sb.append("Insert Into [Check]( Check_Code,Back_Number,Export_Date,Attain_Date,Receive_Date,Check_Number,C_Code_Source,C_Code_Destination,  Daryaft_Pardakht,Sel_check,Vosool,DarJaryan,Cust,Bank_Code,Account_Number,BankToBank,Sanad_Code,  Sanad_Code2,Sanad_Code_Jaryan,Branch,Bargashty,BargashtyDate,Sanad_Code_Bargasht,DarJaryanDate,   Comm,Cash_Id,SellCheck_BargashtToCash,SanadCodeBargashtSellCheck,jaryanCheck_BargashtToCash,   SanadCodeBargashtjaryan,BranchCode,IsEbtal,  SarFaslName_Daryaft,SarFaslName_Kharj,Col_Code,Moien_Code,Tafzili_Code,Col_Code_BankOne,Moien_Code_BankOne,Tafzili_Code_BankOne)");
                break;
            }
            case 4: {
                sb.append("Insert Into NEWBANK(Bank_Code,Bank_Name)");
                break;
            }
            case 5: {
                sb.append("Insert Into Unit(Unit_Code,Unit_Name,Unit_Few)");
                break;
            }
            case 6: {
                sb.append("Insert Into snd_indx(sanad_code,Fac_Code,Fac_Type,Check_Code)");
                break;
            }
            case 7: {
                sb.append("Insert Into Check_Event(check_code,sanad_code,Date_Time,Cash_Id,SarFasl_Code,State)");
                break;
            }
            case 9: {
                sb.append("Insert Into UserDb(PasWord,Name,UserCodeInc,SuperVizor)");
                break;
            }
            case 10: {
                sb.append("Insert Into Msetup2( [Name],[Boolean],[Integer],[Double],[String],[Text])");
                break;
            }
            case 11: {
                sb.append("INSERT INTO RES_FACTURE(F_CODE, F_TYPE, F_CODE_C, F_DATE, F_TIME, C_CODE,  FAC_TYPE, FTYPE_KF)");
                break;
            }
            case 12: {
                sb.append("INSERT INTO RES_FAC_LIST(F_CODE, FL_INDEX, A_CODE, FL_FEW, FL_PRICE, FEWKARTON, FEWBASTEH )");
            }
        }
        return sb;
    }

    private void appendResDetailValues(@NotNull StringBuilder sb, @NotNull InvoiceDetailDto dto) {
        sb.append(" ( ").append("'").append(dto.getId()).append("',").append("'").append(dto.getFl_index()).append("',").append("'").append(dto.getProductid()).append("',").append("'").append(dto.getFew()).append("',").append("'").append(dto.getPrice()).append("',").append("'").append(dto.getKarton()).append("',").append("'").append(dto.getBasteh()).append("'").append(" ) ");
    }

    private void appendResInvoiceValues(@NotNull StringBuilder sb, @NotNull ResInvoiceDto dto) {
        sb.append(" ( ").append("'").append(dto.getId()).append("',").append("'").append(dto.getType()).append("',").append("'").append(dto.getCode()).append("',").append("'").append(dto.getDate()).append("',").append("'").append(dto.getTime()).append("',").append("'").append(dto.getCustomercode()).append("',").append("'").append(dto.getFactype()).append("',").append("'").append(dto.getFtype_kf()).append("'").append(" ) ");
    }

    private void appendSelectSanadStatement(@NotNull StringBuilder sb, @NotNull PaymentDto p) {
        sb.append(" ( ").append(p.getFixsanadcode()).append(",").append(p.getSanadcode()).append(",").append(p.getSanadcode2()).append(",").append("'").append(p.getDate()).append("',").append("'").append(p.getTime()).append("',").append("'").append(p.getComment()).append("',").append(ConvertStr.getBoolToInt((Boolean)p.getEndsave())).append(",").append(ConvertStr.getBoolToInt((Boolean)p.getSavefromfacture())).append(",").append(ConvertStr.getBoolToInt((Boolean)p.getSavefromauto())).append(",").append(p.getSanadtype()).append(",").append(p.getUsercodeinc()).append(",").append(p.getSanadstate()).append(" ) ");
    }

    private void appendSelectSndListStatement(@NotNull StringBuilder sb, @NotNull PaymentDetailDto p, int sanadCode) {
        sb.append(" ( ").append(sanadCode).append(",").append("'").append(p.getColcode()).append("',").append("'").append(p.getMoiencode()).append("',").append("'").append(p.getTafzilicode()).append("',").append(p.getBed()).append(",").append(p.getBes()).append(",").append(ConvertStr.getBoolToInt((Boolean)p.getShowdaftar())).append(",").append(ConvertStr.getBoolToInt((Boolean)p.getJoze())).append(",").append("'").append(p.getTypeline()).append("',").append(p.getNumberline()).append(",").append("'").append(p.getCommentline()).append("',").append(p.getOldscode()).append(" ) ");
    }

    private void appendSelectSndindxStatement(@NotNull StringBuilder sb, @NotNull PaymentDetailSndIndxDto p) {
        sb.append(" ( ").append(p.getSanadcode()).append(",").append("'").append(p.getFaccode()).append("',").append("'").append(p.getFactype()).append("',").append(p.getCheckcode()).append(" ) ");
    }

    private void appendSelectSarfalStatement(@NotNull StringBuilder sb, @NotNull SarfaslDto p) {
        sb.append(" ( ").append("'").append(p.getColcode()).append("',").append("'").append(p.getMoiencode()).append("',").append("'").append(p.getTafzilicode()).append("',").append("'").append(p.getSarfaslcode()).append("',").append("'").append(p.getSarfaslname()).append("',").append(p.getMandeh()).append(",").append(p.getGroup()).append(",").append(p.getMahiat()).append(",").append(ConvertStr.getBoolToInt((Boolean)p.getCandelete())).append(",").append("'").append(p.getCommon()).append("',").append(0).append(",").append(p.getMhazcode()).append(",").append(ConvertStr.getBoolToInt((Boolean)p.getAutouse())).append(",").append(p.getId()).append(",").append(p.getParent()).append(",").append(p.getType()).append(",").append(p.getSparent()).append(" ) ");
    }

    private void appendSelectCheckStatement(@NotNull StringBuilder sb, @NotNull CheckDto p) {
        String sbb = " ( " + p.getCheckcode() + "," + p.getBacknumber() + ",'" + p.getExportdate() + "','" + p.getAttaindate() + "','" + p.getReceivedate() + "','" + p.getChecknumber() + "','" + p.getCcodesource() + "','" + p.getCcodedestination() + "'," + p.getDaryaftpardakht() + "," + p.getSelcheck() + "," + p.getVosool() + "," + p.getDarjaryan() + ",'" + p.getCust() + "'," + ConvertStr.toQuotedSqlStr((String)p.getBankcode()) + ",'" + p.getAccountnumber() + "'," + p.getBanktobank() + "," + p.getSanadcode() + "," + p.getSanadcode2() + "," + p.getSanadcodejaryan() + ",'" + p.getBranch() + "'," + p.getBargashty() + ",'" + p.getBargashtydate() + "'," + p.getSanadcodebargasht() + ",'" + p.getDarjaryandate() + "','" + p.getComm() + "'," + p.getCashid() + "," + p.getSellcheckbargashttocash() + "," + p.getSanadcodebargashtsellcheck() + "," + p.getJaryancheckbargashtToCash() + "," + p.getSanadcodebargashtjaryan() + "," + ConvertStr.toQuotedSqlStr((String)p.getBranchcode()) + "," + p.getIsebtal() + ",'" + ConvertStr.nullSafeString((String)p.getSarfaslnamedaryaft()) + "','" + ConvertStr.nullSafeString((String)p.getSarfaslnamekharj()) + "','" + ConvertStr.nullSafeString((String)p.getColcode()) + "','" + ConvertStr.nullSafeString((String)p.getMoiencode()) + "','" + ConvertStr.nullSafeString((String)p.getTafzilicode()) + "','" + ConvertStr.nullSafeString((String)p.getColcodebankone()) + "','" + ConvertStr.nullSafeString((String)p.getMoiencodebankone()) + "','" + ConvertStr.nullSafeString((String)p.getTafzilicodebankone()) + "' ) ";
        String ss = sbb.replaceAll("true", "1");
        ss = ss.replaceAll("false", "0");
        sb.append(ss);
    }

    private void appendSelectCheckEventStatement(@NotNull StringBuilder sb, @NotNull CheckEventDto p) {
        sb.append(" ( ").append(p.getCheckcode()).append(",").append(p.getSanadcode()).append(",").append("'").append(p.getDatetime()).append("',").append(p.getCashid()).append(",").append("'").append(p.getSarfaslcode()).append("',").append("'").append(p.getState()).append("'").append(" ) ");
    }

    private void appendSelectBankStatement(@NotNull StringBuilder sb, @NotNull BankDto p) {
        sb.append(" ( ").append("'").append(p.getBankcode()).append("',").append("'").append(p.getBankname()).append("'").append(" ) ");
    }

    private void appendSelectUserDbStatement(@NotNull StringBuilder sb, @NotNull LoginDto p) {
        sb.append(" ( ").append("'").append(p.getUserPass()).append("',").append("'").append(p.getUserName()).append("',").append(p.getUserCodeInc()).append(",").append(ConvertStr.getBoolToInt((Boolean)p.getSuperVizor())).append(" ) ");
    }

    private int returnMinMax_CodeSanad_For_OneDay(@NotNull TncJdbc jdbcTemplate, String oneDay) {
        int minCodeSanad = 0;
        int maxCodeSanad = 0;
        boolean lastDate = false;
        String sqlStr = " SELECT     MAX(Sanad_Code_C) AS Code   FROM         dbo.SANAD  WHERE     (Sanad_Date < '" + oneDay + "') ";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        while (rs.next()) {
            minCodeSanad = rs.getInt("Code") + 1;
        }
        sqlStr = " SELECT     MIN(Sanad_Code_C) AS Code   FROM         dbo.SANAD  WHERE     (Sanad_Date > '" + oneDay + "') ";
        rs = jdbcTemplate.queryForRowSet(sqlStr);
        while (rs.next()) {
            maxCodeSanad = rs.getInt("Code");
        }
        if (maxCodeSanad == 0) {
            sqlStr = " SELECT  MAX(Sanad_Code_C) AS Code  FROM    dbo.SANAD  WHERE   (Sanad_Date <= '" + oneDay + "') ";
            rs = jdbcTemplate.queryForRowSet(sqlStr);
            while (rs.next()) {
                maxCodeSanad = rs.getInt("Code") + 1;
            }
            lastDate = true;
        }
        if (!lastDate) {
            if (minCodeSanad < maxCodeSanad) {
                --maxCodeSanad;
            } else if (minCodeSanad == maxCodeSanad) {
                maxCodeSanad = --minCodeSanad;
            }
            if (maxCodeSanad < minCodeSanad) {
                maxCodeSanad = minCodeSanad;
            }
            if (maxCodeSanad < 2) {
                maxCodeSanad = 2;
            }
        }
        return maxCodeSanad;
    }

    private int returnSanadCode2(JdbcTemplate jdbcTemplate, int sanadCode, String sanadDate) {
        int sanadCode2 = 0;
        sanadDate = sanadDate.replace("-", "/");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
        Date tmpSanadDate = null;
        try {
            tmpSanadDate = formatter.parse(sanadDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        SqlRowSet rs = jdbcTemplate.queryForRowSet(" SELECT      Sanad_Code_C, Sanad_Code_C2, Sanad_Date  FROM         dbo.SANAD  WHERE     (Sanad_Code_C = " + sanadCode + ") ORDER BY Sanad_Code_C2");
        if (rs.next()) {
            sanadCode2 = rs.getInt("Sanad_Code_C2") + 1;
            while (rs.next()) {
                assert (tmpSanadDate != null);
                if (!Objects.requireNonNull(rs.getDate("Sanad_Date")).before(tmpSanadDate) && !Objects.equals(rs.getDate("Sanad_Date"), tmpSanadDate)) continue;
                sanadCode2 = rs.getInt("Sanad_Code_C2") + 1;
            }
        }
        return sanadCode2;
    }

    private void incSanadCode(JdbcTemplate jdbcTemplate, int firstCode, int firstCode2) {
        if (firstCode2 <= 0) {
            return;
        }
        SqlRowSet rs = jdbcTemplate.queryForRowSet(" SELECT COUNT(Sanad_Code_C) AS Code  FROM dbo.SANAD  WHERE Sanad_Code_C = " + firstCode);
        while (rs.next()) {
            if (rs.getInt("Code") <= 0) continue;
            jdbcTemplate.execute(" UPDATE Sanad  SET Sanad_Code_C2 = Sanad_Code_C2 + 1  WHERE Sanad_Code_C = " + firstCode + " AND Sanad_Code_C2 >= " + firstCode2);
        }
    }

    private void sanadAdd(@NotNull PaymentDetailDto.Builder paymentBuilder) {
        this.sndList.add(paymentBuilder.build());
    }

    public List<Map<String, Object>> getBanksList() {
        LoginDto login = this.dbConnection.setToken();
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate(login);
        return jdbc.queryForList("SELECT BANK_CODE bankCode, BANK_NAME bankName FROM NewBank");
    }

    public List<Map<String, Object>> getCityList() {
        LoginDto login = this.dbConnection.setToken();
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate(login);
        return jdbc.queryForList("SELECT CITY_CODE cityCode, [NAME] cityName FROM [CITY]");
    }

    public List<Map<String, Object>> getAccountsList(HttpServletRequest request) {
        LoginDto login = this.dbConnection.setToken();
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate(login);
        String whereStr = this.makeAccountWhereStr(request);
        return jdbc.queryForList("SELECT NEWBANK.BANK_CODE bankCode, ACCOUNT_N accountNumber, BRANCH_NUMBER branchNumber, BRANCH_NAME branchName, COL_CODE + MOIEN_CODE + TAFZILI_CODE sarfaslCode, POS hasPOS, SHEBA_NUM sheba, KART_NUM cardNumber, MyNameAcound accOwnerName, BANK_NAME bankName FROM dbo.ACOUND_N\n INNER JOIN dbo.NEWBANK ON dbo.ACOUND_N.Bank_Code = dbo.NEWBANK.Bank_Code\n WHERE dbo.ACOUND_N.IsActive = 1" + whereStr);
    }

    private String makeAccountWhereStr(HttpServletRequest request) {
        Map mReq = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        String sql = "";
        if (mReq.containsKey("iscurrent") && mReq.containsKey("haspos")) {
            if (sql.isEmpty()) {
                sql = sql + "AND JARY_HASANEH = " + ConvertStr.getBoolToInt((Boolean)Boolean.parseBoolean((String)mReq.get("iscurrent")));
            }
            sql = sql + " AND pos = " + ConvertStr.getBoolToInt((Boolean)Boolean.parseBoolean((String)mReq.get("haspos")));
        } else if (mReq.containsKey("iscurrent")) {
            sql = sql + " AND JARY_HASANEH = " + ConvertStr.getBoolToInt((Boolean)Boolean.parseBoolean((String)mReq.get("iscurrent")));
        }
        if (mReq.containsKey("haspos")) {
            sql = sql + " AND pos = " + ConvertStr.getBoolToInt((Boolean)Boolean.parseBoolean((String)mReq.get("haspos")));
        }
        return sql;
    }

    public synchronized ResponseEntity<Map<String, Object>> postPaymentList(String body, int fRegisterType, boolean rebuildJson) {
        PaymentDto[] paymentDto;
        try {
            if (rebuildJson) {
                JSONObject obj = new JSONObject(body);
                obj = ConvertStr.rebuildJsonObject((JSONObject)obj);
                JSONArray jsonArray = obj.getJSONArray("payinfo");
                body = jsonArray.toString();
            } else {
                body = body.substring(11, body.length() - 1);
            }
            Gson gson = new Gson();
            paymentDto = (PaymentDto[])gson.fromJson(body, PaymentDto[].class);
        }
        catch (Exception ignored) {
            TncException t = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
            return ConvertStr.getMapResponseEntity((String)"Payment", Collections.singletonList(t.getErrorMap()), Collections.emptyList());
        }
        return this.postPaymentList(paymentDto, fRegisterType);
    }

    public synchronized ResponseEntity<Map<String, Object>> postPaymentList(PaymentDto[] paymentDtoArray, int fRegisterType) {
        ArrayList<PaymentDto> myArrClass = new ArrayList<PaymentDto>();
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList<Map> success = new ArrayList<Map>();
        LoginDto myLogin = this.dbConnection.setToken();
        PaymentProcessDao processDao = new PaymentProcessDao(this.dbConnection, myLogin, JsonDeserializer.toJson((Object)paymentDtoArray));
        for (PaymentDto payment : paymentDtoArray) {
            if (payment.getFixsanadcode() != 0) {
                myArrClass.add(payment);
                continue;
            }
            try {
                this.doInsertSanad(fRegisterType, payment, myLogin);
                processDao.insert(payment, ProcessDao.ProcessKind.ADD);
                Map successModel = ConvertStr.buildMap(model -> {
                    if (!ConvertStr.isNullOrEmpty((String)payment.getInputid())) {
                        model.put("Id", payment.getInputid());
                    }
                    model.put("ErpCode", ConvertStr.encrypt((String)String.valueOf(payment.getFixsanadcode())));
                    model.put("FixSanadCode", payment.getFixsanadcode());
                    if (payment.getSanadCodeC2() > 0) {
                        model.put("SanadCode", payment.getSanadCodeC() + "/" + payment.getSanadCodeC2());
                    } else {
                        model.put("SanadCode", payment.getSanadCodeC());
                    }
                });
                success.add(successModel);
            }
            catch (TncException e) {
                if (!ConvertStr.isNullOrEmpty((String)payment.getInputid())) {
                    e.putMoreInfo("Id", (Object)payment.getInputid());
                }
                failure.add(e.getErrorMap());
            }
            catch (Exception ex) {
                TncException t = new TncException(TncExceptionMessages.DEFAULT_ERROR);
                failure.add(t.getErrorMap());
            }
        }
        if (!myArrClass.isEmpty()) {
            try {
                this.insertOrDeleteSanad(myLogin, myArrClass);
            }
            catch (Exception ex) {
                failure.add(this.makeErrorWithCause(ex));
            }
            if (failure.isEmpty()) {
                LinkedHashMap<String, Boolean> model2 = new LinkedHashMap<String, Boolean>();
                model2.put("Success", true);
                success.add(model2);
            }
        }
        return ConvertStr.getMapResponseEntity((String)"Payment", failure, success);
    }

    public long doInsertSanad(int fRegisterType, PaymentDto payment, LoginDto myLogin) {
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        CheckDao checkDao = new CheckDao(this.dbConnection, myLogin);
        this.sndList.clear();
        if (fRegisterType != 0) {
            payment.setSanadtype(fRegisterType);
        }
        payment.setInputid(payment.getId());
        if (ConvertStr.isNullOrEmpty((String)payment.getDate()) || payment.getDate().length() != 10) {
            throw new TncException(TncExceptionMessages.INVALID_DATE);
        }
        if (ConvertStr.isNullOrEmpty((String)payment.getTime()) || payment.getTime().length() < 5) {
            throw new TncException(TncExceptionMessages.INVALID_TIME);
        }
        if (payment.getBank() == null) {
            payment.setBank(Double.valueOf(0.0));
        }
        if (payment.getCash() == null) {
            payment.setCash(Double.valueOf(0.0));
        }
        if (payment.getDiscount() == null) {
            payment.setDiscount(Double.valueOf(0.0));
        }
        this.checkPayBank(payment, myLogin);
        this.checkPayCash(payment, myLogin);
        if (payment.hasPartialPayments() && payment.getBank().doubleValue() != payment.calcBankAmounts()) {
            throw new TncException(TncExceptionMessages.UNEVEN_POS_PRICES_DOCUMENT);
        }
        if (payment.getDiscount() < 0.0) {
            throw new TncException(TncExceptionMessages.INVALID_DISCOUNT_AMOUNT);
        }
        if (payment.calcBankAmounts() + payment.getCash() + payment.getDiscount() <= 0.0 && ConvertStr.isNullOrEmpty((Collection)payment.getChecks())) {
            throw new TncException(TncExceptionMessages.UNSPECIFIED_PRICE);
        }
        if (ConvertStr.isNullOrEmpty((String)payment.getCustomersarfasl())) {
            throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_HEADING);
        }
        String sqlStr = "Select Sarfasl_Name, Common From Sarfasl Where Sarfasl_Code='" + payment.getCustomersarfasl() + "' And [type] in (5,15) And Sparent = 0 ";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        while (rs.next()) {
            payment.setCustomerName(rs.getString("Sarfasl_Name"));
            payment.setCustomerCode(rs.getString("Common"));
        }
        if (ConvertStr.isNullOrEmpty((String)payment.getCustomerName())) {
            throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_HEADING);
        }
        if (!ConvertStr.isNullOrEmpty((String)payment.getBanksarfasl())) {
            sqlStr = "Select Sarfasl_Name From Sarfasl  Where Sarfasl_Code='" + payment.getBanksarfasl() + "'";
            rs = jdbcTemplate.queryForRowSet(sqlStr);
            while (rs.next()) {
                payment.setBankHeadingName(rs.getString("Sarfasl_Name"));
            }
        }
        payment.setSanadCodeC(this.returnMinMax_CodeSanad_For_OneDay(jdbcTemplate, payment.getDate()));
        payment.setSanadCodeC2(this.returnSanadCode2((JdbcTemplate)jdbcTemplate, payment.getSanadCodeC(), payment.getDate()));
        this.incSanadCode((JdbcTemplate)jdbcTemplate, payment.getSanadCodeC(), payment.getSanadCodeC2());
        checkDao.findCheckErrors(payment);
        this.dbConnection.getTransactionTemplate(myLogin).executeWithoutResult(status -> {
            double sumChecks;
            String sComment;
            String sql = this.makeInsertSanadSql(payment, myLogin);
            jdbcTemplate.execute(sql);
            payment.setFixsanadcode((int)GetIdentity.invoke((TncJdbc)jdbcTemplate));
            checkDao.insertChecks(payment);
            if (payment.getSanadtype() == 3) {
                this.sanadAdd(PaymentDetailDto.builder().colcode(payment.getBanksarfasl().substring(0, 3)).moiencode(payment.getBanksarfasl().substring(3, 7)).tafzilicode(payment.fetchBankTafsili()).bed(payment.getBank()).typeline("Z").commentline("\u062f\u0631\u064a\u0627\u0641\u062a \u062d\u0648\u0627\u0644\u0647 \u0627\u0632 " + payment.getCustomerName()));
                if (payment.getDiscount() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode("601").moiencode("0007").bed(payment.getDiscount()).typeline("Z").commentline("\u067e\u0631\u062f\u0627\u062e\u062a \u062a\u062e\u0641\u064a\u0641 \u0628\u0647 " + payment.getCustomerName()));
                }
                this.sanadAdd(PaymentDetailDto.builder().colcode(payment.getCustomersarfasl().substring(0, 3)).moiencode(payment.getCustomersarfasl().substring(3, 7)).tafzilicode(payment.getCustomersarfasl().substring(7)).bes(Double.valueOf(payment.getBank() + payment.getDiscount())).typeline("S").commentline("\u062f\u0631\u064a\u0627\u0641\u062a \u062d\u0648\u0627\u0644\u0647 \u0648\u0627\u0631\u064a\u0632\u064a \u0628\u0647 " + payment.getBankHeadingName()));
            } else if (payment.getSanadtype() == 4) {
                sComment = "";
                if (payment.getCash() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(payment.getCashsarfasl().substring(0, 3)).moiencode(payment.getCashsarfasl().substring(3, 7)).tafzilicode(payment.getCashsarfasl().substring(7)).bed(payment.getCash()).typeline("Z").commentline("\u062f\u0631\u064a\u0627\u0641\u062a \u0627\u0632 " + payment.getCustomerName()));
                    sComment = sComment + "\u0646\u0642\u062f ";
                }
                if (payment.calcBankAmounts() > 0.0) {
                    if (payment.hasPartialPayments()) {
                        for (PaymentDto.BankPaymentData pos : payment.getPartialbankpayments()) {
                            this.addBankHeadingReceive(pos.getBanksarfasl(), pos.getBank(), payment.getCustomerName());
                        }
                    } else {
                        this.addBankHeadingReceive(payment.getBanksarfasl(), payment.getBank().doubleValue(), payment.getCustomerName());
                    }
                    sComment = sComment + "\u0643\u0627\u0631\u062a ";
                }
                if (payment.getDiscount() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode("601").moiencode("0007").bed(payment.getDiscount()).typeline("Z").commentline("\u067e\u0631\u062f\u0627\u062e\u062a \u062a\u062e\u0641\u064a\u0641 \u0628\u0647 " + payment.getCustomerName()));
                    sComment = sComment + "\u062a\u062e\u0641\u064a\u0641 ";
                }
                sumChecks = 0.0;
                if (!ConvertStr.isNullOrEmpty((Collection)payment.getChecks())) {
                    for (CheckDto check : payment.getChecks()) {
                        this.sanadAdd(PaymentDetailDto.builder().colcode(check.getCheckSarfasl().substring(0, 3)).moiencode(check.getCheckSarfasl().substring(3, 7)).tafzilicode(check.getCheckSarfasl().substring(7)).bed(check.getCust()).typeline("Z").numberline(Double.valueOf(check.getCheckcode())).commentline("\u062f\u0631\u06cc\u0627\u0641\u062a \u0686\u06a9 \u0627\u0632 " + payment.getCustomerName()));
                        sumChecks += check.getCust().doubleValue();
                    }
                    sComment = sComment + "\u0686\u06a9 ";
                }
                this.sanadAdd(PaymentDetailDto.builder().colcode(payment.getCustomersarfasl().substring(0, 3)).moiencode(payment.getCustomersarfasl().substring(3, 7)).tafzilicode(payment.getCustomersarfasl().substring(7)).bes(Double.valueOf(payment.getCash() + payment.calcBankAmounts() + payment.getDiscount() + sumChecks)).typeline("S").commentline("\u062f\u0631\u064a\u0627\u0641\u062a \u0628\u0635\u0648\u0631\u062a " + sComment));
            } else if (payment.getSanadtype() == 5) {
                sComment = "";
                if (payment.getCash() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(payment.getCashsarfasl().substring(0, 3)).moiencode(payment.getCashsarfasl().substring(3, 7)).tafzilicode(payment.getCashsarfasl().substring(7)).bes(payment.getCash()).typeline("Z").commentline("\u067e\u0631\u062f\u0627\u062e\u062a \u0628\u0647 " + payment.getCustomerName()));
                    sComment = sComment + "\u0646\u0642\u062f ";
                }
                if (payment.calcBankAmounts() > 0.0) {
                    if (payment.hasPartialPayments()) {
                        for (PaymentDto.BankPaymentData pos : payment.getPartialbankpayments()) {
                            this.addBankHeadingPay(pos.getBanksarfasl(), pos.getBank(), payment.getCustomerName());
                        }
                    } else {
                        this.addBankHeadingPay(payment.getBanksarfasl(), payment.getBank().doubleValue(), payment.getCustomerName());
                    }
                    sComment = sComment + "\u0643\u0627\u0631\u062a ";
                }
                if (payment.getDiscount() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode("702").moiencode("0002").bes(payment.getDiscount()).typeline("Z").commentline("\u062f\u0631\u06cc\u0627\u0641\u062a \u062a\u062e\u0641\u064a\u0641 \u0627\u0632 " + payment.getCustomerName()));
                    sComment = sComment + "\u062a\u062e\u0641\u064a\u0641 ";
                }
                sumChecks = 0.0;
                if (!ConvertStr.isNullOrEmpty((Collection)payment.getChecks())) {
                    for (CheckDto check : payment.getChecks()) {
                        this.sanadAdd(PaymentDetailDto.builder().colcode(check.getCheckSarfasl().substring(0, 3)).moiencode(check.getCheckSarfasl().substring(3, 7)).tafzilicode(check.getCheckSarfasl().substring(7)).bes(check.getCust()).typeline("Z").numberline(Double.valueOf(check.getCheckcode())).commentline("\u067e\u0631\u062f\u0627\u062e\u062a \u0686\u06a9 \u0628\u0647 " + payment.getCustomerName()));
                        sumChecks += check.getCust().doubleValue();
                    }
                    sComment = sComment + "\u0686\u06a9 ";
                }
                this.sanadAdd(PaymentDetailDto.builder().colcode(payment.getCustomersarfasl().substring(0, 3)).moiencode(payment.getCustomersarfasl().substring(3, 7)).tafzilicode(payment.getCustomersarfasl().substring(7)).bed(Double.valueOf(payment.getCash() + payment.calcBankAmounts() + payment.getDiscount() + sumChecks)).typeline("S").commentline("\u067e\u0631\u062f\u0627\u062e\u062a \u0628\u0635\u0648\u0631\u062a " + sComment));
            }
            for (PaymentDetailDto dto : this.sndList) {
                sql = " Insert Into Snd_List(Sanad_Code, Col_Code, Moien_Code, Tafzili_Code, Bed, Bes, Joze, Show_Daftar,Type_Line, Comment_Line, Number_Line, Actions)  Values(" + payment.getFixsanadcode() + ",'" + dto.getColcode() + "','" + dto.getMoiencode() + "','" + dto.getTafzilicode() + "'," + dto.getBed() + "," + dto.getBes() + "," + ConvertStr.getBoolToInt((Boolean)dto.getJoze()) + "," + ConvertStr.getBoolToInt((Boolean)dto.getShowdaftar()) + ",'" + dto.getTypeline() + "','" + dto.getCommentline() + "'," + dto.getNumberline() + "," + dto.getActions() + ")";
                jdbcTemplate.execute(sql);
            }
        });
        return payment.getFixsanadcode();
    }

    private void addBankHeadingPay(String bankHeading, double bankAmount, String customerName) {
        this.sanadAdd(PaymentDetailDto.builder().colcode(bankHeading.substring(0, 3)).moiencode(bankHeading.substring(3, 7)).tafzilicode(bankHeading.substring(7)).bes(Double.valueOf(bankAmount)).typeline("Z").commentline("\u067e\u0631\u062f\u0627\u062e\u062a \u0628\u0647 " + customerName));
    }

    private void addBankHeadingReceive(String bankHeading, double bankAmount, String customerName) {
        this.sanadAdd(PaymentDetailDto.builder().colcode(bankHeading.substring(0, 3)).moiencode(bankHeading.substring(3, 7)).tafzilicode(bankHeading.substring(7)).bed(Double.valueOf(bankAmount)).typeline("Z").commentline("\u062f\u0631\u064a\u0627\u0641\u062a \u0627\u0632 " + customerName));
    }

    private void checkPayCash(PaymentDto payment, LoginDto myLogin) throws TncException {
        CheckPayError payError = new CheckPayError(this.dbConnection, this.sarfaslDao);
        CheckPayError.PayErrorType payErrorType = payError.checkErrorPay(payment.getCash().doubleValue(), payment.getCashsarfasl(), CheckPayError.SarfaslType.CASH, myLogin);
        if (payErrorType.equals((Object)CheckPayError.PayErrorType.SARFASL_ERROR)) {
            throw new TncException(TncExceptionMessages.INVALID_CASH_HEADING);
        }
        if (payErrorType.equals((Object)CheckPayError.PayErrorType.PRICE_ERROR)) {
            throw new TncException(TncExceptionMessages.INVALID_CASH_AMOUNT);
        }
    }

    private void checkPayBank(PaymentDto payment, LoginDto myLogin) throws TncException {
        CheckPayError payError = new CheckPayError(this.dbConnection, this.sarfaslDao);
        CheckPayError.PayErrorType payErrorType = CheckPayError.PayErrorType.NO_ERROR;
        if (payment.getSanadtype() == 3) {
            return;
        }
        if (payment.hasPartialPayments()) {
            for (PaymentDto.BankPaymentData pos : payment.getPartialbankpayments()) {
                payErrorType = payError.checkErrorPay(pos.getBank(), pos.getBanksarfasl(), CheckPayError.SarfaslType.CARD, myLogin);
                if (payErrorType.equals((Object)CheckPayError.PayErrorType.SARFASL_ERROR)) {
                    payment.setBanksarfasl(pos.getBanksarfasl());
                } else if (!payErrorType.equals((Object)CheckPayError.PayErrorType.PRICE_ERROR)) continue;
                break;
            }
        } else {
            payErrorType = payError.checkErrorPay(payment.getBank().doubleValue(), payment.getBanksarfasl(), CheckPayError.SarfaslType.CARD, myLogin);
        }
        if (payErrorType.equals((Object)CheckPayError.PayErrorType.SARFASL_ERROR)) {
            throw new TncException(TncExceptionMessages.INVALID_CARD_HEADING.setArgs(new Object[]{payment.getBanksarfasl()}));
        }
        if (payErrorType.equals((Object)CheckPayError.PayErrorType.PRICE_ERROR)) {
            throw new TncException(TncExceptionMessages.INVALID_CARD_AMOUNT);
        }
    }

    @Language(value="SQL")
    @NotNull
    private String makeInsertSanadSql(PaymentDto payment, LoginDto myLogin) {
        int action = payment.getAction() == null ? (payment.getBank() > 0.0 ? 1 : 0) : payment.getAction();
        return " INSERT INTO SANAD(Sanad_Code_C, Sanad_Code_C2, Comment, Sanad_Date, Sanad_Time, End_Save, SaveFromFacture, SaveFromAuto, User1, NaghdCheck, DateUser, TimeUser, UserCodeInc, Actions, Number_U, Sanad_Type,EndeditDate)  VALUES(" + payment.getSanadCodeC() + "," + payment.getSanadCodeC2() + ", '" + ConvertStr.nullSafeString((String)payment.getComment()) + "', '" + payment.getDate() + "', '" + payment.getTime() + "', 0, 0, 0, 0, 0, convert(Nvarchar(10), getdate(), 111),  convert(Nvarchar(5), getdate(), 108), " + myLogin.getUserCodeInc() + ", " + action + ", 0, " + payment.getSanadtype() + ", getdate())";
    }

    void insertOrDeleteSanad(LoginDto login, List<PaymentDto> paymentList) {
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate(login);
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDatabaseName()).transactionDeadLockWrapper(() -> this.insertSanad((JdbcTemplate)jdbc, paymentList), new String[]{"SANAD", "SND_LIST", "SARFASL", "SND_INDX"});
        }
        catch (Exception ex) {
            SetOffIdentInsert.invoke((TncJdbc)jdbc, (String)"sanad");
            this.deleteRepeatSanad(login, paymentList);
            if (ConvertStr.exceptionContains((Exception)ex, (String)"duplicate key")) {
                this.insertOrDeleteSanad(login, paymentList);
            }
            throw ex;
        }
    }

    private void insertSanad(JdbcTemplate jdbcTemplate, @NotNull List<PaymentDto> paymentDtoList) {
        int j;
        int i;
        String on = "set identity_insert sanad on";
        String off = "set identity_insert sanad off";
        int m = 0;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < paymentDtoList.size(); ++i) {
            ++m;
            if (sb.length() > 0) {
                sb.append(" , ");
            }
            this.appendSelectSanadStatement(sb, paymentDtoList.get(i));
            if (m <= 50) continue;
            sb = this.getInsertStatement(0).append("values ").append((CharSequence)sb);
            jdbcTemplate.execute(on + "\n" + sb + "\n" + off);
            m = 0;
            sb.delete(0, sb.length());
        }
        if (m > 0) {
            sb = this.getInsertStatement(0).append("values ").append((CharSequence)sb);
            jdbcTemplate.execute(on + "\n" + sb + "\n" + off);
        }
        m = 0;
        sb.delete(0, sb.length());
        for (i = 0; i < paymentDtoList.size(); ++i) {
            int sanadCode = paymentDtoList.get(i).getFixsanadcode();
            for (j = 0; j < paymentDtoList.get(i).getDetail().size(); ++j) {
                ++m;
                if (sb.length() > 0) {
                    sb.append(" , ");
                }
                this.appendSelectSndListStatement(sb, (PaymentDetailDto)paymentDtoList.get(i).getDetail().get(j), sanadCode);
                if (m <= 50) continue;
                sb = this.getInsertStatement(1).append("values ").append((CharSequence)sb);
                jdbcTemplate.execute(sb.toString());
                m = 0;
                sb.delete(0, sb.length());
            }
        }
        if (m > 0) {
            sb = this.getInsertStatement(1).append("values ").append((CharSequence)sb);
            jdbcTemplate.execute(sb.toString());
        }
        if (paymentDtoList.get(0).getDetailsndindx() != null) {
            m = 0;
            sb.delete(0, sb.length());
            for (i = 0; i < paymentDtoList.size(); ++i) {
                for (j = 0; j < paymentDtoList.get(i).getDetailsndindx().size(); ++j) {
                    ++m;
                    if (sb.length() > 0) {
                        sb.append(" , ");
                    }
                    this.appendSelectSndindxStatement(sb, (PaymentDetailSndIndxDto)paymentDtoList.get(i).getDetailsndindx().get(j));
                    if (m <= 50) continue;
                    sb = this.getInsertStatement(6).append("values ").append((CharSequence)sb);
                    jdbcTemplate.execute(sb.toString());
                    m = 0;
                    sb.delete(0, sb.length());
                }
            }
            if (m > 0) {
                sb = this.getInsertStatement(6).append("values ").append((CharSequence)sb);
                jdbcTemplate.execute(sb.toString());
            }
        }
    }

    private void deleteRepeatSanad(@NotNull LoginDto login, List<PaymentDto> paymentDtoList) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDatabaseName()).transactionDeadLockWrapper(() -> {
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
            int i = 0;
            while (i < paymentDtoList.size()) {
                StringBuilder sanadCode = new StringBuilder(String.valueOf(((PaymentDto)paymentDtoList.get(i)).getFixsanadcode()));
                ++i;
                for (int j = 0; j < 50 && i < paymentDtoList.size(); ++j, ++i) {
                    sanadCode.append(",").append(((PaymentDto)paymentDtoList.get(i)).getFixsanadcode());
                }
                jdbcTemplate.update(" Delete Snd_indx Where Sanad_Code in (" + sanadCode + ")");
                jdbcTemplate.update(" Delete Snd_List Where Sanad_Code in (" + sanadCode + ")");
                jdbcTemplate.update(" Delete Sanad Where Sanad_Code in (" + sanadCode + ")");
            }
        }, new String[]{"SND_INDX", "SND_LIST", "SANAD"});
    }

    public synchronized ResponseEntity<Map<String, Object>> postSarfaslList(String body) {
        SarfaslDto[] sarfaslArray;
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        LoginDto myLogin = this.dbConnection.setToken();
        try {
            body = body.substring(15, body.length() - 1);
            Gson gson = new Gson();
            sarfaslArray = (SarfaslDto[])gson.fromJson(body, SarfaslDto[].class);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            failure.add(exception.getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"Sarfasl", failure, success);
        }
        try {
            this.insertOrDeleteSarfasl(myLogin, sarfaslArray);
        }
        catch (Exception ex) {
            this.log.error("dbName: " + myLogin.getDatabaseName() + " - insert sarfasl error: " + ex);
            failure.add(this.makeErrorWithCause(ex));
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"Sarfasl", failure, success);
    }

    private Map<String, Object> makeErrorWithCause(Exception e) {
        TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
        return exception.makeErrorWithCause((Throwable)e);
    }

    void insertOrDeleteSarfasl(LoginDto login, SarfaslDto[] sarfaslDtoArray) {
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDatabaseName()).transactionDeadLockWrapper(() -> {
                String on = " set identity_insert Sarfasl on ";
                String off = " set identity_insert Sarfasl off ";
                int i = 0;
                while (i < sarfaslDtoArray.length) {
                    StringBuilder sb = this.getInsertStatement(2);
                    sb.append("values ");
                    this.appendSelectSarfalStatement(sb, sarfaslDtoArray[i]);
                    ++i;
                    for (int j = 0; j < 50 && i < sarfaslDtoArray.length; ++j, ++i) {
                        sb.append(" , ");
                        this.appendSelectSarfalStatement(sb, sarfaslDtoArray[i]);
                    }
                    jdbcTemplate.execute(on + "\n" + sb + "\n" + off);
                    this.log.info("dbName: " + login.getDatabaseName() + " - insert sarfasl: " + sb);
                }
            }, new String[]{"SARFASL"});
        }
        catch (Exception ex) {
            SetOffIdentInsert.invoke((TncJdbc)jdbcTemplate, (String)"sarfasl");
            this.deleteRepeatSarfasl(login, sarfaslDtoArray);
            if (ExceptionUtils.noNeedToReInsert((Exception)ex)) {
                this.log.info("dbName: " + login.getDatabaseName() + " -* exception: " + ex);
                throw ex;
            }
            this.insertOrDeleteSarfasl(login, sarfaslDtoArray);
        }
    }

    private void deleteRepeatSarfasl(@NotNull LoginDto login, SarfaslDto[] sarfaslDtoArray) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDatabaseName()).transactionDeadLockWrapper(() -> {
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
            int i = 0;
            while (i < sarfaslDtoArray.length) {
                StringBuilder sarfaslCode = new StringBuilder("'" + sarfaslDtoArray[i].getSarfaslcode() + "'");
                ++i;
                for (int j = 0; j < 50 && i < sarfaslDtoArray.length; ++j, ++i) {
                    sarfaslCode.append(",'").append(sarfaslDtoArray[i].getSarfaslcode()).append("'");
                }
                this.log.info("dbName: " + login.getDatabaseName() + " -* codes: " + sarfaslCode);
                int num = jdbcTemplate.update(" Delete Sarfasl Where Sarfasl_Code in (" + sarfaslCode + ")");
                this.log.info("dbName: " + login.getDatabaseName() + " -* deletedRows: " + num);
            }
        }, new String[]{"SARFASL"});
    }

    public synchronized ResponseEntity<Map<String, Object>> postCheckList(String body) {
        CheckDto[] checkDto;
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        LoginDto myLogin = this.dbConnection.setToken();
        try {
            body = body.substring(13, body.length() - 1);
            Gson gson = new Gson();
            checkDto = (CheckDto[])gson.fromJson(body, CheckDto[].class);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            failure.add(exception.getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"Check", failure, success);
        }
        try {
            this.insertOrDeleteCheque(myLogin, checkDto);
        }
        catch (Exception ex) {
            failure.add(this.makeErrorWithCause(ex));
            return ConvertStr.getMapResponseEntity((String)"Check", failure, success);
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"Check", failure, success);
    }

    void insertOrDeleteCheque(LoginDto login, CheckDto[] chequeArray) {
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate(login);
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDatabaseName()).transactionDeadLockWrapper(() -> this.insertCheque((JdbcTemplate)jdbc, chequeArray), new String[]{"CHECK"});
        }
        catch (Exception ex) {
            SetOffIdentInsert.invoke((TncJdbc)jdbc, (String)"[Check]");
            this.deleteRepeatCheque(login, chequeArray);
            if (ConvertStr.exceptionContains((Exception)ex, (String)"duplicate key")) {
                this.insertOrDeleteCheque(login, chequeArray);
            }
            throw ex;
        }
    }

    private void insertCheque(JdbcTemplate jdbcTemplate, @NotNull CheckDto[] chequeArray) {
        String on = "set identity_insert [Check] on";
        String off = "set identity_insert [Check] off";
        int i = 0;
        while (i < chequeArray.length) {
            StringBuilder sb = this.getInsertStatement(3);
            sb.append("values ");
            this.appendSelectCheckStatement(sb, chequeArray[i]);
            ++i;
            for (int j = 0; j < 50 && i < chequeArray.length; ++j, ++i) {
                sb.append(" , ");
                this.appendSelectCheckStatement(sb, chequeArray[i]);
            }
            jdbcTemplate.execute(on + "\n" + sb + "\n" + off);
        }
    }

    private void deleteRepeatCheque(@NotNull LoginDto login, CheckDto[] chequeArray) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDatabaseName()).transactionDeadLockWrapper(() -> {
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
            int i = 0;
            while (i < chequeArray.length) {
                StringBuilder CheckCode = new StringBuilder(String.valueOf(chequeArray[i].getCheckcode()));
                ++i;
                for (int j = 0; j < 50 && i < chequeArray.length; ++j, ++i) {
                    CheckCode.append(",").append(chequeArray[i].getCheckcode());
                }
                jdbcTemplate.update(" Delete [Check] Where Check_Code in (" + CheckCode + ")");
            }
        }, new String[]{"CHECK"});
    }

    public synchronized ResponseEntity<Map<String, Object>> postBankList(String body) {
        BankDto[] bankDto;
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        LoginDto myLogin = this.dbConnection.setToken();
        try {
            body = body.substring(12, body.length() - 1);
            Gson gson = new Gson();
            bankDto = (BankDto[])gson.fromJson(body, BankDto[].class);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            failure.add(exception.getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"Bank", failure, success);
        }
        try {
            this.insertOrDeleteBank(myLogin, bankDto);
        }
        catch (Exception ex) {
            failure.add(this.makeErrorWithCause(ex));
            return ConvertStr.getMapResponseEntity((String)"Bank", failure, success);
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"Bank", failure, success);
    }

    void insertOrDeleteBank(LoginDto login, BankDto[] bankArray) {
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDatabaseName()).transactionDeadLockWrapper(() -> this.insertBank((JdbcTemplate)this.dbConnection.getJdbcTemplate(login), bankArray), new String[]{"NewBank"});
        }
        catch (Exception ex) {
            this.deleteRepeatBank(login, bankArray);
            if (ConvertStr.exceptionContains((Exception)ex, (String)"duplicate key")) {
                this.insertOrDeleteBank(login, bankArray);
            }
            throw ex;
        }
    }

    void insertBank(JdbcTemplate jdbcTemplate, @NotNull BankDto[] bankArray) {
        int i = 0;
        while (i < bankArray.length) {
            StringBuilder sb = this.getInsertStatement(4);
            sb.append("values ");
            this.appendSelectBankStatement(sb, bankArray[i]);
            ++i;
            for (int j = 0; j < 50 && i < bankArray.length; ++j, ++i) {
                sb.append(" , ");
                this.appendSelectBankStatement(sb, bankArray[i]);
            }
            jdbcTemplate.execute(sb.toString());
        }
    }

    private void deleteRepeatBank(@NotNull LoginDto login, BankDto[] bankArray) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDatabaseName()).transactionDeadLockWrapper(() -> {
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
            int i = 0;
            while (i < bankArray.length) {
                StringBuilder bankCode = new StringBuilder(String.valueOf(bankArray[i].getBankcode()));
                ++i;
                for (int j = 0; j < 50 && i < bankArray.length; ++j, ++i) {
                    bankCode.append(",'").append(bankArray[i].getBankcode()).append("'");
                }
                jdbcTemplate.update(" Delete NewBank Where Bank_Code in (" + bankCode + ")");
            }
        }, new String[]{"NewBank"});
    }

    public synchronized ResponseEntity<Map<String, Object>> postUserDbList(String body) {
        LoginDto[] loginDto;
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        LoginDto myLogin = this.dbConnection.setToken();
        try {
            body = body.substring(12, body.length() - 1);
            GsonBuilder gsonBuilder = new GsonBuilder();
            if (myLogin.getIsMyHoloo().booleanValue()) {
                gsonBuilder.setFieldNamingStrategy(f -> Character.toUpperCase(f.getName().charAt(0)) + f.getName().substring(1));
            }
            Gson gson = gsonBuilder.create();
            loginDto = (LoginDto[])gson.fromJson(body, LoginDto[].class);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            failure.add(exception.getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"User", failure, success);
        }
        try {
            this.insertOrDeleteUser(myLogin, loginDto);
        }
        catch (Exception ex) {
            failure.add(this.makeErrorWithCause(ex));
            return ConvertStr.getMapResponseEntity((String)"User", failure, success);
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"User", failure, success);
    }

    void insertOrDeleteUser(LoginDto login, LoginDto[] loginArray) {
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDatabaseName()).transactionDeadLockWrapper(() -> {
                this.deleteRepeatUserDb(login, loginArray);
                this.insertUserDb((JdbcTemplate)this.dbConnection.getJdbcTemplate(login), loginArray);
            }, new String[]{"UserDB"});
        }
        catch (Exception ex) {
            this.deleteRepeatUserDb(login, loginArray);
            if (ConvertStr.exceptionContains((Exception)ex, (String)"duplicate key")) {
                this.insertOrDeleteUser(login, loginArray);
            }
            throw ex;
        }
    }

    private void insertUserDb(JdbcTemplate jdbcTemplate, @NotNull LoginDto[] loginArray) {
        int i = 0;
        while (i < loginArray.length) {
            StringBuilder sb = this.getInsertStatement(9);
            sb.append("values ");
            this.appendSelectUserDbStatement(sb, loginArray[i]);
            ++i;
            for (int j = 0; j < 50 && i < loginArray.length; ++j, ++i) {
                sb.append(" , ");
                this.appendSelectUserDbStatement(sb, loginArray[i]);
            }
            jdbcTemplate.execute(sb.toString());
        }
        jdbcTemplate.execute("if (Select Count(*) From UserDb where Name='TncCloud')=0 Insert Into UserDb (name,PasWord,SuperVizor,UserCodeInc,SaveSpdSel,DeActive) Select 'TncCloud','1',0,-10,0,1 From UserDb  ");
    }

    private void deleteRepeatUserDb(@NotNull LoginDto login, LoginDto[] userArray) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDatabaseName()).transactionDeadLockWrapper(() -> {
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
            int i = 0;
            while (i < userArray.length) {
                StringBuilder userCodeInc = new StringBuilder(String.valueOf(userArray[i].getUserCodeInc()));
                ++i;
                for (int j = 0; j < 50 && i < userArray.length; ++j, ++i) {
                    userCodeInc.append(",").append(userArray[i].getUserCodeInc());
                }
                jdbcTemplate.update(" Delete UserDb Where UserCodeInc in (" + userCodeInc + ")  And name<>'TncCloud' ");
            }
        }, new String[]{"UserDB"});
    }

    public synchronized ResponseEntity<Map<String, Object>> postSettingList(String body) {
        SettingDto[] settingDto;
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        LoginDto myLogin = this.dbConnection.setToken();
        try {
            body = body.substring(15, body.length() - 1);
            Gson gson = new Gson();
            settingDto = (SettingDto[])gson.fromJson(body, SettingDto[].class);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            failure.add(exception.getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"Settings", failure, success);
        }
        try {
            this.insertOrDeleteSetting(myLogin, settingDto);
        }
        catch (Exception ex) {
            failure.add(this.makeErrorWithCause(ex));
            return ConvertStr.getMapResponseEntity((String)"Settings", failure, success);
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"Settings", failure, success);
    }

    void insertOrDeleteSetting(LoginDto loginDto, SettingDto[] settingArray) {
        SettingBulkInsert settingBulkInsert = new SettingBulkInsert(this.dbConnection);
        settingBulkInsert.bulkInsert(loginDto, Arrays.asList(settingArray));
    }

    public synchronized ResponseEntity<Map<String, Object>> postResInvoice(String body) {
        ResInvoiceDto[] resInvoiceDtoArray;
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        LoginDto myLogin = this.dbConnection.setToken();
        try {
            body = body.substring(15, body.length() - 1);
            Gson gson = new Gson();
            resInvoiceDtoArray = (ResInvoiceDto[])gson.fromJson(body, ResInvoiceDto[].class);
        }
        catch (Exception ex) {
            failure.add(new TncException(TncExceptionMessages.WRONG_JSON_STRUCT).getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"ResInvoice", failure, success);
        }
        try {
            this.insertOrDeleteResInvoice(myLogin, resInvoiceDtoArray);
        }
        catch (Exception ex) {
            failure.add(this.makeErrorWithCause(ex));
            return ConvertStr.getMapResponseEntity((String)"ResInvoice", failure, success);
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"ResInvoice", failure, success);
    }

    void insertOrDeleteResInvoice(LoginDto myLogin, ResInvoiceDto[] resInvoiceDtoArray) {
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate(myLogin);
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDatabaseName()).transactionDeadLockWrapper(() -> this.insertResInvoice((JdbcTemplate)jdbc, resInvoiceDtoArray), new String[]{"RES_FACTURE", "RES_FAC_LIST"});
        }
        catch (Exception ex) {
            SetOffIdentInsert.invoke((TncJdbc)jdbc, (String)"RES_FACTURE");
            this.deleteRepeatResInvoice(myLogin, resInvoiceDtoArray);
            if (ConvertStr.exceptionContains((Exception)ex, (String)"duplicate key")) {
                this.insertOrDeleteResInvoice(myLogin, resInvoiceDtoArray);
            }
            throw ex;
        }
    }

    private void insertResInvoice(JdbcTemplate jdbcTemplate, @NotNull ResInvoiceDto[] resInvoiceArray) {
        String on = " set identity_insert RES_FACTURE on ";
        String off = " set identity_insert RES_FACTURE off ";
        StringBuilder invoiceInsertBuilder = new StringBuilder(this.getResInvoiceInsert());
        StringBuilder dtlInsertBuilder = new StringBuilder(this.getResDtlInsert());
        int counterInvoice = 0;
        for (ResInvoiceDto resInvoice : resInvoiceArray) {
            if (counterInvoice >= 50) {
                jdbcTemplate.update(ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)invoiceInsertBuilder.insert(0, on), (String)",") + off);
                invoiceInsertBuilder.delete(0, invoiceInsertBuilder.length());
                invoiceInsertBuilder.append(this.getResInvoiceInsert());
                counterInvoice = 0;
            }
            this.appendResInvoiceValues(invoiceInsertBuilder, resInvoice);
            invoiceInsertBuilder.append(" , ");
            for (InvoiceDetailDto dtl : resInvoice.getDetailinfo()) {
                this.appendResDetailValues(dtlInsertBuilder, dtl);
                dtlInsertBuilder.append(" , ");
            }
            jdbcTemplate.update(ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)dtlInsertBuilder, (String)",").toString());
            dtlInsertBuilder.delete(0, dtlInsertBuilder.length());
            dtlInsertBuilder.append(this.getResDtlInsert());
            ++counterInvoice;
        }
        if (invoiceInsertBuilder.length() > 0) {
            ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)invoiceInsertBuilder, (String)",");
        }
        jdbcTemplate.update(invoiceInsertBuilder.insert(0, on) + off);
    }

    @NotNull
    private String getResInvoiceInsert() {
        return this.getInsertStatement(11).append(" VALUES ").toString();
    }

    @NotNull
    private String getResDtlInsert() {
        return this.getInsertStatement(12).append(" VALUES ").toString();
    }

    private void deleteRepeatResInvoice(@NotNull LoginDto login, ResInvoiceDto[] resInvoiceArray) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDatabaseName()).transactionDeadLockWrapper(() -> {
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
            int i = 0;
            while (i < resInvoiceArray.length) {
                StringBuilder codes = new StringBuilder("'" + resInvoiceArray[i].getId() + "'");
                ++i;
                for (int j = 0; j < 50 && i < resInvoiceArray.length; ++j, ++i) {
                    codes.append(",'").append(resInvoiceArray[i].getId()).append("'");
                }
                jdbcTemplate.update(" Delete RES_FACTURE Where F_CODE in (" + codes + ") ");
                jdbcTemplate.update(" Delete RES_FAC_LIST Where F_CODE in (" + codes + ") ");
            }
        }, new String[]{"RES_FACTURE", "RES_FAC_LIST"});
    }

    public synchronized ResponseEntity<Map<String, Object>> postCheckEventList(String body) {
        CheckEventDto[] checkEventArray;
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        LoginDto myLogin = this.dbConnection.setToken();
        try {
            body = body.substring(13, body.length() - 1);
            Gson gson = new Gson();
            checkEventArray = (CheckEventDto[])gson.fromJson(body, CheckEventDto[].class);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
            failure.add(exception.getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"CheckEvent", failure, success);
        }
        try {
            this.insertOrDeleteCheckEvent(myLogin, checkEventArray);
        }
        catch (Exception ex) {
            failure.add(this.makeErrorWithCause(ex));
            return ConvertStr.getMapResponseEntity((String)"CheckEvent", failure, success);
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"CheckEvent", failure, success);
    }

    void insertOrDeleteCheckEvent(LoginDto login, CheckEventDto[] checkEventArray) {
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDatabaseName()).transactionDeadLockWrapper(() -> this.insertCheckEvent((JdbcTemplate)this.dbConnection.getJdbcTemplate(login), checkEventArray), new String[]{"CHECK_EVENT"});
        }
        catch (Exception ex) {
            this.deleteRepeatCheckEvent(login, checkEventArray);
            if (ConvertStr.exceptionContains((Exception)ex, (String)"duplicate key")) {
                this.insertOrDeleteCheckEvent(login, checkEventArray);
            }
            throw ex;
        }
    }

    private void insertCheckEvent(JdbcTemplate jdbcTemplate, @NotNull CheckEventDto[] checkEventArray) {
        int i = 0;
        while (i < checkEventArray.length) {
            StringBuilder sb = this.getInsertStatement(7);
            sb.append("values ");
            this.appendSelectCheckEventStatement(sb, checkEventArray[i]);
            ++i;
            for (int j = 0; j < 50 && i < checkEventArray.length; ++j, ++i) {
                sb.append(" , ");
                this.appendSelectCheckEventStatement(sb, checkEventArray[i]);
            }
            jdbcTemplate.execute(sb.toString());
        }
    }

    private void deleteRepeatCheckEvent(@NotNull LoginDto login, CheckEventDto[] checkEventArray) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDatabaseName()).transactionDeadLockWrapper(() -> {
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
            int i = 0;
            while (i < checkEventArray.length) {
                StringBuilder key = new StringBuilder("'" + checkEventArray[i].getCheckcode() + checkEventArray[i].getSanadcode() + "'");
                ++i;
                for (int j = 0; j < 50 && i < checkEventArray.length; ++j, ++i) {
                    key.append(",").append(checkEventArray[i].getCheckcode()).append(checkEventArray[i].getSanadcode());
                }
                jdbcTemplate.update(" Delete Check_Event Where Cast(Check_Code as nvarchar(10)) + Cast(Sanad_Code as nvarchar(10)) in (" + key + ")");
            }
        }, new String[]{"CHECK_EVENT"});
    }

    public synchronized ResponseEntity<Map<String, Object>> deleteTableList(String body) {
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        LoginDto myLogin = this.dbConnection.setToken();
        try {
            Gson gson = new Gson();
            DeleteTable[] deleteTables = (DeleteTable[])gson.fromJson(body, DeleteTable[].class);
            deleteTables[0].updateCodes(this.dbConnection, myLogin);
            deleteTables[0].performDelete(myLogin, this.dbConnection);
            LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
            model.put("Success", true);
            success.add(model);
            deleteTables[0].callApi(myLogin, this.dbConnection);
        }
        catch (Exception e) {
            this.log.error("dbName: " + myLogin.getDatabaseName() + " - delete table error: " + e);
            TncException exception = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
            failure.add(exception.getErrorMap());
        }
        return ConvertStr.getMapResponseEntity((String)"DeleteTable", failure, success);
    }

    public synchronized ResponseEntity<Map<String, Object>> dropDataBase() {
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        try {
            jdbcTemplate.execute("USE [master] \n ALTER DATABASE " + myLogin.getDatabaseName() + " SET SINGLE_USER WITH ROLLBACK IMMEDIATE \n ");
            jdbcTemplate.execute("USE [master] \n ALTER DATABASE " + myLogin.getDatabaseName() + " SET multi_user WITH ROLLBACK IMMEDIATE \n ");
            String drop = "USE [master] \n  Drop Database " + myLogin.getDatabaseName();
            jdbcTemplate.execute(drop);
            this.log.info("drop db:" + drop);
            myLogin.setDatabaseName(myLogin.getDatabaseName().substring(myLogin.getDatabaseName().indexOf("_") + 1, myLogin.getDatabaseName().lastIndexOf("]")));
            this.dbConnection.createDataBase(myLogin);
            LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
            model.put("Success", true);
            success.add(model);
        }
        catch (Exception e) {
            this.log.error("dbName: " + myLogin.getDatabaseName() + " - drop db error: " + e);
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            failure.add(exception.getErrorMap());
        }
        return ConvertStr.getMapResponseEntity((String)"DropDataBase", failure, success);
    }

    public synchronized ResponseEntity<?> insertPosLog(PosTransactionDto[] body) {
        LoginDto loginDto = this.dbConnection.setToken();
        if (!loginDto.isPosLog()) {
            return ConvertStr.getMapResponseEntity((String)"PosLog", Collections.singletonList(Collections.singletonMap("Success", false)), Collections.emptyList());
        }
        loginDto.setDatabaseName("PosLog");
        try {
            List notInsertedPosLogs = this.makeNonInsertedPosLogList((JdbcTemplate)this.dbConnection.getJdbcTemplate(loginDto), body);
            this.batchInsertPosLog(loginDto, notInsertedPosLogs);
            return ConvertStr.getMapResponseEntity((String)"PosLog", Collections.emptyList(), Collections.singletonList(Collections.singletonMap("Success", true)));
        }
        catch (Exception e) {
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            return ConvertStr.getMapResponseEntity((String)"PosLog", Collections.singletonList(exception.makeErrorWithCause((Throwable)e)), Collections.emptyList());
        }
    }

    private void batchInsertPosLog(LoginDto loginDto, List<PosTransactionDto> posDtoList) {
        PosLogBulkInsert bulkInsert = new PosLogBulkInsert(this.dbConnection);
        bulkInsert.bulkInsert(loginDto, posDtoList);
    }

    private List<PosTransactionDto> makeNonInsertedPosLogList(JdbcTemplate jdbcTemplate, @NotNull PosTransactionDto[] body) {
        HashSet<String> uncStrList = new HashSet<String>();
        HashSet<String> posSerialSet = new HashSet<String>();
        HashSet<String> userSerialSet = new HashSet<String>();
        for (PosTransactionDto dto2 : body) {
            uncStrList.add(dto2.getUncStr());
            posSerialSet.add(dto2.getPosSerial());
            userSerialSet.add(dto2.getSerialCode());
        }
        String uncStr = ConvertStr.bindStringsWrapByCharacter(uncStrList, (String)"('", (String)"')");
        String pSerials = ConvertStr.commaBindStringsWithQuotes(posSerialSet);
        String uSerials = ConvertStr.commaBindStringsWithQuotes(userSerialSet);
        List nonInsertedUncStr = jdbcTemplate.queryForList(" USE POSLOG \n SELECT DISTINCT * FROM (VALUES " + uncStr + ") AS UncStrList(UncStr) WHERE UncStrList.UncStr NOT IN (SELECT ResultPosInt64 + POS_SERIAL + SerialCode FROM PosTrans WHERE SerialCode IN (" + uSerials + ") AND Pos_Serial IN (" + pSerials + "))");
        Set notInserted = nonInsertedUncStr.stream().map(map -> map.getOrDefault("UncStr", "")).collect(Collectors.toSet());
        return Arrays.stream(body).filter(dto -> notInserted.contains(dto.getUncStr())).distinct().collect(Collectors.toList());
    }

    public ResponseEntity<?> postProxyVoucher(@NotNull List<ProxyVoucherDto> body) {
        LoginDto login = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        String responseName = "ProxyVoucher";
        ArrayList successResult = new ArrayList();
        HashMap successMap = new HashMap();
        for (ProxyVoucherDto dto : body) {
            ResponseEntity response = (ResponseEntity)this.dbConnection.getTransactionTemplate(login).execute(status -> {
                try {
                    this.checkProxyVoucherErrors(dto);
                    int codeC = this.returnMinMax_CodeSanad_For_OneDay(jdbcTemplate, dto.getDate());
                    int codeC2 = this.returnSanadCode2((JdbcTemplate)jdbcTemplate, codeC, dto.getDate());
                    this.incSanadCode((JdbcTemplate)jdbcTemplate, codeC, codeC2);
                    String sqlStr = " INSERT INTO SANAD(Sanad_Code_C, Sanad_Code_C2, Comment, Sanad_Date, Sanad_Time, End_Save, SaveFromFacture, SaveFromAuto, User1, NaghdCheck, DateUser, TimeUser, UserCodeInc, Actions, Number_U, Sanad_Type,EndeditDate)  VALUES(" + codeC + "," + codeC2 + ",'" + (dto.getComment() == null ? "" : dto.getComment()) + "','" + dto.getDate() + "','" + dto.getTime() + "', 0, 0, 0, 0, 0, convert(Nvarchar(10),getdate(),111), convert(Nvarchar(5),getdate(),108)," + login.getUserCodeInc() + ",0, 0, 20, getdate())";
                    jdbcTemplate.execute(sqlStr);
                    SqlRowSet rs = jdbcTemplate.queryForRowSet(" Select SCOPE_IDENTITY() SanadCode ");
                    while (rs.next()) {
                        dto.setFixVoucherCode(rs.getInt("SanadCode"));
                    }
                    for (ProxyVoucherDtl dtl : dto.getDetailInfo()) {
                        this.checkVoucherDtlErrors(dtl, jdbcTemplate);
                        String colCode = dtl.getSarfasl().substring(0, 3);
                        String moienCode = dtl.getSarfasl().substring(3, 7);
                        String tafsiliCode = dtl.getSarfasl().substring(7);
                        tafsiliCode = ConvertStr.isNullOrEmpty((String)tafsiliCode) ? "" : tafsiliCode;
                        sqlStr = " INSERT INTO SND_LIST(SANAD_CODE, COL_CODE, MOIEN_CODE, TAFZILI_CODE, BED, BES, JOZE, SHOW_DAFTAR, COMMENT_LINE)  VALUES(" + dto.getFixVoucherCode() + ",'" + colCode + "','" + moienCode + "','" + tafsiliCode + "'," + dtl.getDebt() + "," + dtl.getCredit() + ", 0, 1,'" + dtl.getCommentLine() + "')";
                        jdbcTemplate.execute(sqlStr);
                    }
                    successMap.put("Success", true);
                    successMap.put("SanadCode", dto.getFixVoucherCode());
                    successResult.add(successMap);
                }
                catch (TncException e) {
                    status.setRollbackOnly();
                    return ConvertStr.getMapResponseEntity((String)responseName, Collections.singletonList(e.getErrorMap()), Collections.emptyList());
                }
                catch (Exception e) {
                    status.setRollbackOnly();
                    TncException ex = new TncException(TncExceptionMessages.DEFAULT_ERROR);
                    return ConvertStr.getMapResponseEntity((String)responseName, Collections.singletonList(ex.makeErrorWithCause((Throwable)e)), Collections.emptyList());
                }
                return null;
            });
            if (response == null) continue;
            return response;
        }
        return ConvertStr.getMapResponseEntity((String)responseName, Collections.emptyList(), successResult);
    }

    private void checkProxyVoucherErrors(ProxyVoucherDto dto) throws TncException {
        if (ConvertStr.isNullOrEmpty((String)dto.getDate()) || dto.getDate().length() != 10) {
            throw new TncException(TncExceptionMessages.INVALID_DATE);
        }
        if (ConvertStr.isNullOrEmpty((String)dto.getTime()) || dto.getTime().length() < 5) {
            throw new TncException(TncExceptionMessages.INVALID_TIME);
        }
        double debtSum = 0.0;
        double creditSum = 0.0;
        for (ProxyVoucherDtl dtl : dto.getDetailInfo()) {
            if (dtl.getDebt() != null && dtl.getDebt() > 0.0 && dtl.getCredit() != null && dtl.getCredit() > 0.0) {
                throw new TncException(TncExceptionMessages.BOTH_DEBT_AND_CREDIT_HAVE_AMOUNTS);
            }
            debtSum += dtl.getDebt() != null ? dtl.getDebt() : 0.0;
            creditSum += dtl.getCredit() != null ? dtl.getCredit() : 0.0;
        }
        if (debtSum != creditSum || debtSum == 0.0) {
            throw new TncException(TncExceptionMessages.UNEQUAL_DEBTS_AND_CREDITS);
        }
    }

    private void checkVoucherDtlErrors(@NotNull ProxyVoucherDtl dtl, TncJdbc jdbcTemplate) throws TncException {
        if (ConvertStr.isNullOrEmpty((String)dtl.getSarfasl()) || dtl.getSarfasl().length() < 7) {
            throw new TncException(TncExceptionMessages.INVALID_HEADING);
        }
        if (this.headingNotAvailable(dtl.getSarfasl(), jdbcTemplate)) {
            throw new TncException(TncExceptionMessages.INVALID_HEADING);
        }
    }

    private boolean headingNotAvailable(String heading, @NotNull TncJdbc jdbcTemplate) {
        SqlRowSet rs = jdbcTemplate.queryForRowSet("SELECT COUNT(Sarfasl_Name) CNT From SARFASL WHERE Sarfasl_Code='" + heading + "' AND Sparent = 0 ");
        if (rs.next()) {
            return rs.getInt("CNT") == 0;
        }
        return true;
    }

    public ResponseEntity<?> deleteProxyVoucher(String voucherCode) {
        LoginDto login = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        String responseName = "ProxyVoucher";
        HashMap successMap = new HashMap();
        return (ResponseEntity)this.dbConnection.getTransactionTemplate(login).execute(status -> {
            try {
                Integer count = (Integer)jdbcTemplate.queryForObject(" SELECT COUNT(SANAD_CODE) CNT FROM SANAD WHERE SANAD_CODE = ?", Integer.class, new Object[]{voucherCode});
                if (count == null || count == 0) {
                    throw new TncException(TncExceptionMessages.INVALID_VOUCHER_CODE);
                }
                jdbcTemplate.update(" DELETE FROM SANAD WHERE SANAD_CODE = ?", new Object[]{voucherCode});
                jdbcTemplate.update(" DELETE FROM SND_LIST WHERE SANAD_CODE = ?", new Object[]{voucherCode});
                successMap.put("Success", true);
                successMap.put("SanadCode", voucherCode);
                return ConvertStr.getMapResponseEntity((String)responseName, Collections.emptyList(), Collections.singletonList(successMap));
            }
            catch (TncException e) {
                status.setRollbackOnly();
                return ConvertStr.getMapResponseEntity((String)responseName, Collections.singletonList(e.getErrorMap()), Collections.emptyList());
            }
            catch (Throwable e) {
                status.setRollbackOnly();
                TncException ex = new TncException(TncExceptionMessages.DEFAULT_ERROR);
                return ConvertStr.getMapResponseEntity((String)responseName, Collections.singletonList(ex.makeErrorWithCause(e)), Collections.emptyList());
            }
        });
    }

    public ApiResponse<ValidateVoucherResponse> validateVoucher(String username, String voucherRef) {
        try {
            String token = this.kainoLoginUseCase.invoke();
            ResponseEntity response = this.validateVoucherUseCase.invoke(username, voucherRef, token);
            if (response.getStatusCode().is2xxSuccessful() && ((ValidateVoucherResponse)response.getBody()).getTransactions() != null && ((ValidateVoucherResponse)response.getBody()).getTransactions().size() > 0) {
                return new ApiResponse.Success(response.getBody(), "SUCCEESS", true);
            }
            return new ApiResponse.Error("\u062a\u0631\u0627\u06a9\u0646\u0634 \u06cc\u0627\u0641\u062a \u0646\u0634\u062f", null, false);
        }
        catch (Exception e) {
            if (e instanceof TncException) {
                return new ApiResponse.Error(e.getMessage(), Integer.valueOf(((TncException)((Object)e)).getErrorCode()), false);
            }
            return new ApiResponse.Error(e.getMessage(), Integer.valueOf(500), false);
        }
    }

    public ApiResponse<ValidateMobileResponse> validateMobile(String username) {
        try {
            String token = this.kainoLoginUseCase.invoke();
            ResponseEntity response = this.validateMobileUseCase.invoke(username, token);
            if (response.getStatusCode().is2xxSuccessful()) {
                return new ApiResponse.Success(response.getBody(), "SUCCEESS", true);
            }
            return new ApiResponse.Error("\u06a9\u0627\u0631\u0628\u0631 \u06cc\u0627\u0641\u062a \u0646\u0634\u062f", null, false);
        }
        catch (Exception e) {
            if (e instanceof TncException) {
                return new ApiResponse.Error(e.getMessage(), Integer.valueOf(((TncException)((Object)e)).getErrorCode()), false);
            }
            return new ApiResponse.Error(e.getMessage(), Integer.valueOf(500), false);
        }
    }
}

